/*
 *	Announce.c
 *
 *	by Manuel A. Perez
 *
 *
 *	10/22/93 - first version reads named 'snd ' from a resource file.
 *             Change it later to read named files from a specific
 *             folder.  For example, a folder name 'AdaEd Sounds' with
 *             named files inside.  This will be easier for students
 *             to create their own sound files. 
 */
/*
 * Copyright (C) 1985-1992  New York University
 * Copyright (C) 1994 George Washington University
 * 
 * This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
 * system.  See the Ada/Ed README file for warranty (none) and distribution
 * info and also the GNU General Public License for more details.
 */


#include "Announce.h"
#include <Sound.h>
#include <TBUtilities.h>

// These two identify the resource (STR#) in the application
// that has the folder name for the sound files
#define kRsrcID 20010
#define kRsrcIndex 2


static	void	OpenSoundFile(Str255 file);
static	void	CloseSoundFile(void);

static	short	refNum = -1;


/****
 *	OpenSoundFile
 *
 *	Open the resource file that has the sounds.  Use the name stored
 *	in the resource fork of the application.
 *
 ****/

void	OpenSoundFile(Str255 file)
{
Str255	folderName;


	GetIndString(folderName, kRsrcID, kRsrcIndex);
	ConcatPStrings(folderName, file);
	refNum = OpenResFile(folderName);
	if (refNum != -1)
		UseResFile(refNum);
}

/****
 *	CloseSoundFile
 *
 *	Close the resource file with the sounds
 *
 ****/

void	CloseSoundFile(void)
{
	if (refNum != -1)
		CloseResFile(refNum);
	refNum = -1;
}

/****
 *	Announce
 *
 *	Play a sound based on the name of the resource.
 *
 ****/

void	Announce(Str255 soundName)
{
Handle sound;
short count;


	OpenSoundFile(soundName);					// open file
	if (refNum != -1) {

		count = Count1Resources('snd ');		// count sound resources
		if (count > 0) {
			sound = Get1IndResource('snd ', 1);	// load first one there

			if (sound) {
		
				SndPlay(NULL, sound, false);	// play it
				ReleaseResource(sound);			// release it (unnecessary)
			}
		}

		CloseSoundFile();						// close sound file
	}
}
